-- ************************************
-- sp_RecomputeQuotaCountersWithoutOnlineReset
-- ************************************
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_RecomputeQuotaCountersWithoutOnlineReset]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[sp_RecomputeQuotaCountersWithoutOnlineReset]
GO

CREATE PROCEDURE [dbo].[sp_RecomputeQuotaCountersWithoutOnlineReset] 
	@projectId  int  ,
	@UserId int 
AS

--Get the replicate option from installation table
declare @replicate bit 
select @replicate=InsValue from installation where insident = 'QUOTASMODEREPLICATE' 


IF @replicate=1 
BEGIN 
	UPDATE Quota 
	SET	qtunused=unused, 
		qtfrequence=completed, 
		qtonline=online 
	FROM Quota 
	inner join (	SELECT	stratum, 
							sum(unused) as unused, 
							sum(completed) as completed, 
							sum(online) as online 
					FROM 
						(	SELECT	qtstratum as stratum, 
									case when rescall=0			then COALESCE(IncrementValue,1) else 0 end as unused, 
									case when rescompleted=1	then COALESCE(IncrementValue,1) else 0 end as completed, 
									case when rescallbackdate>0 then COALESCE(IncrementValue,1) else 0 end as online 
							FROM quota 
								left outer join stratum WITH (NOLOCK) on Quota.QtQuotaId = Stratum.StrQuotaId
								left outer join respondent WITH (NOLOCK) on strrespondent=resrespondent 
							WHERE qtstratum > 0 ) a 
					GROUP BY stratum ) b on stratum=qtstratum 
END
ELSE 
BEGIN 
	UPDATE Quota 
	SET		qtunused=unused, 
			qtfrequence=completed 
	FROM Quota 
		inner join (	SELECT	stratum, 
								sum(unused) as unused, 
								sum(completed) as completed 
						FROM 
							(	SELECT	qtstratum as stratum, 
										case when rescall=0			then COALESCE(IncrementValue,1) else 0 end as unused, 
										case when rescompleted=1	then COALESCE(IncrementValue,1) else 0 end as completed 
								FROM quota 
									left outer join stratum WITH (NOLOCK) on Quota.QtQuotaId= Stratum.StrQuotaId
									left outer join respondent  WITH (NOLOCK) on strrespondent=resrespondent 
								WHERE qtstratum > 0 ) a 
						GROUP BY stratum ) b on stratum=qtstratum 
END



UPDATE respondent 
SET resintervcall=newintervcall 
FROM respondent 
		inner join (	SELECT	respondent, 
								case 
									when qtgroup=0 then '' 
									when qtgroup < 10 then 'G0' + cast(qtgroup as varchar) 
									else 'G'+cast (qtgroup as varchar) end as newintervcall 
						FROM
							(	SELECT	resrespondent as respondent, 
										max(qtgroup) as qtgroup 
								FROM
									(	SELECT	resrespondent, 
												qtgroup 
										FROM quota 
											inner join stratum on Stratum.StrQuotaId=Quota.QtQuotaId
											inner join (	SELECT resrespondent 
															from respondent where rescall=0 and (resintervcall='' or resintervcall='***' or resintervcall like 'G[0-9][0-9]') ) a on resrespondent = strrespondent ) b group by resrespondent ) c ) d on resrespondent = respondent 

-- Update Global Quota
UPDATE  Quota 
SET		qtunused	=	( select count(resrespondent) from respondent  WITH (NOLOCK) where rescall=0 ),
		qtfrequence	=	( select count(resrespondent) from respondent  WITH (NOLOCK) where rescompleted=1 ) 
WHERE qtstratum=0



--Update frequency for quotasagent (CAPI)
UPDATE  QuotasAgent
SET  frequency=isnull(completed , 0)
FROM QuotasAgent left join
(
	SELECT ResIntervCall AgentId, Stratum.StrQuotaId as QuotaId , SUM(IncrementValue)  as Completed 
	FROM    
			Respondent WITH (NOLOCK)
			Inner Join Stratum   WITH (NOLOCK) on Stratum.StrRespondent = Respondent.ResRespondent 
	WHERE ResCompleted = 1 and IsNumeric(ResIntervCall) = 1
	GROUP BY ResIntervCall, Stratum.StrQuotaId 
) QuotaAgentFreq
on		QuotaAgentFreq.QuotaId = QuotasAgent.QuotaId  AND QuotasAgent.AgentId = QuotaAgentFreq.AgentId
WHERE frequency <> isnull(completed , 0)


